/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.cmdprograms;

import com.tino1b2be.cmdprograms.TestResult;
import com.tino1b2be.cmdprograms.TestThread;
import com.tino1b2be.dtmfdecoder.DTMFDecoderException;
import com.tino1b2be.dtmfdecoder.DTMFUtil;
import com.tino1b2be.dtmfdecoder.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class CompareDecoders {
    public static void main(String[] args) throws DTMFDecoderException, InterruptedException, IOException {
        ArrayList<File> parents = FileUtil.getDirs("/media/tino1b2be/lin_2/tt/");
        DTMFUtil.goertzel = false;
        ArrayList<Double> times = new ArrayList<Double>();
        for (File dir : parents) {
            times.add(CompareDecoders.runTests(dir));
        }
        FileUtil.writeToFile(times, "Times for FFT.txt");
        System.out.println("Done with FFT");
        times = new ArrayList();
        DTMFUtil.goertzel = true;
        for (File dir : parents) {
            times.add(CompareDecoders.runTests(dir));
        }
        FileUtil.writeToFile(times, "Times for Goertzel.txt");
        System.out.println("Done with Goertzel");
    }

    private static double runTests(File dir) throws InterruptedException, IOException, DTMFDecoderException {
        TestThread[] testThreads;
        ArrayList<ArrayList<File>> testThreadFiles = new ArrayList<ArrayList<File>>();
        ArrayList<File> testFiles = FileUtil.getFiles(dir, ".wav");
        CompareDecoders.setUpThreadFiles(testThreadFiles, testFiles);
        TestResult[] results = new TestResult[testFiles.size()];
        double startT = System.currentTimeMillis();
        for (TestThread thread : testThreads = CompareDecoders.startThreads(testThreadFiles, results)) {
            thread.join();
        }
        double stopT = System.currentTimeMillis();
        return stopT - startT;
    }

    private static TestThread[] startThreads(ArrayList<ArrayList<File>> testThreadFiles, TestResult[] results) {
        int i;
        TestThread[] testThreads = new TestThread[testThreadFiles.size()];
        int start = 0;
        int stop = 0;
        for (i = 0; i < testThreadFiles.size() - 1; ++i) {
            stop = start + testThreadFiles.get(i).size();
            testThreads[i] = new TestThread(testThreadFiles.get(i), results, start);
            testThreads[i].start();
            start = stop;
        }
        testThreads[i] = new TestThread(testThreadFiles.get(i), results, start);
        testThreads[i].run();
        return testThreads;
    }

    private static void setUpThreadFiles(ArrayList<ArrayList<File>> testThreadFiles, ArrayList<File> testFiles) {
        int index = 0;
        do {
            ArrayList<File> threadFiles = new ArrayList<File>();
            threadFiles.add(testFiles.get(index++));
            while (index % 1000 != 0 && index < testFiles.size()) {
                threadFiles.add(testFiles.get(index));
                ++index;
            }
            testThreadFiles.add(threadFiles);
        } while (index < testFiles.size());
    }
}

